/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.api;

public class Point {
    private final int x;
    private final int y;

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public String toString() {
        return "Point{x=" + this.x + ", y=" + this.y + "}";
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int distanceTo(Point other) {
        return (int)Math.hypot(this.getX() - other.getX(), this.getY() - other.getY());
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + this.x;
        hash = 23 * hash + this.y;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point other = (Point)obj;
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }
}

