/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.api;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.runelite.api.Client;
import net.runelite.api.Model;
import net.runelite.api.Point;
import net.runelite.api.SpritePixels;
import net.runelite.api.Varbits;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.model.Jarvis;
import net.runelite.api.model.Triangle;
import net.runelite.api.model.Vertex;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;

public class Perspective {
    private static final double UNIT = 0.0030679615757712823;
    public static final int LOCAL_COORD_BITS = 7;
    public static final int LOCAL_TILE_SIZE = 128;
    public static final int LOCAL_HALF_TILE_SIZE = 64;
    public static final int SCENE_SIZE = 104;
    public static final int[] SINE = new int[2048];
    public static final int[] COSINE = new int[2048];

    @Nullable
    public static Point localToCanvas(@Nonnull Client client2, @Nonnull LocalPoint point, int plane) {
        return Perspective.localToCanvas(client2, point, plane, 0);
    }

    @Nullable
    public static Point localToCanvas(@Nonnull Client client2, @Nonnull LocalPoint point, int plane, int zOffset) {
        int tileHeight = Perspective.getTileHeight(client2, point, plane);
        return Perspective.localToCanvas(client2, point.getX(), point.getY(), tileHeight - zOffset);
    }

    public static Point localToCanvas(@Nonnull Client client2, int x, int y, int z) {
        if (x >= 128 && y >= 128 && x <= 13056 && y <= 13056) {
            x -= client2.getCameraX();
            y -= client2.getCameraY();
            z -= client2.getCameraZ();
            int cameraPitch = client2.getCameraPitch();
            int cameraYaw = client2.getCameraYaw();
            int pitchSin = SINE[cameraPitch];
            int pitchCos = COSINE[cameraPitch];
            int yawSin = SINE[cameraYaw];
            int yawCos = COSINE[cameraYaw];
            int var8 = yawCos * x + y * yawSin >> 16;
            y = yawCos * y - yawSin * x >> 16;
            x = var8;
            var8 = pitchCos * z - y * pitchSin >> 16;
            if ((y = z * pitchSin + y * pitchCos >> 16) >= 50) {
                int pointX = client2.getViewportWidth() / 2 + x * client2.getScale() / y;
                int pointY = client2.getViewportHeight() / 2 + var8 * client2.getScale() / y;
                return new Point(pointX + client2.getViewportXOffset(), pointY + client2.getViewportYOffset());
            }
        }
        return null;
    }

    @Nullable
    public static Point localToMinimap(@Nonnull Client client2, @Nonnull LocalPoint point) {
        return Perspective.localToMinimap(client2, point, 6400);
    }

    @Nullable
    public static Point localToMinimap(@Nonnull Client client2, @Nonnull LocalPoint point, int distance) {
        int y;
        LocalPoint localLocation = client2.getLocalPlayer().getLocalLocation();
        int x = point.getX() / 32 - localLocation.getX() / 32;
        int dist = x * x + (y = point.getY() / 32 - localLocation.getY() / 32) * y;
        if (dist < distance) {
            Widget minimapDrawWidget = client2.isResized() ? (client2.getVar(Varbits.SIDE_PANELS) == 1 ? client2.getWidget(WidgetInfo.RESIZABLE_MINIMAP_DRAW_AREA) : client2.getWidget(WidgetInfo.RESIZABLE_MINIMAP_STONES_DRAW_AREA)) : client2.getWidget(WidgetInfo.FIXED_VIEWPORT_MINIMAP_DRAW_AREA);
            if (minimapDrawWidget == null || minimapDrawWidget.isHidden()) {
                return null;
            }
            int angle = client2.getMapAngle() & 0x7FF;
            int sin = SINE[angle];
            int cos = COSINE[angle];
            int xx = y * sin + cos * x >> 16;
            int yy = sin * x - y * cos >> 16;
            Point loc = minimapDrawWidget.getCanvasLocation();
            int miniMapX = loc.getX() + xx + minimapDrawWidget.getWidth() / 2;
            int miniMapY = minimapDrawWidget.getHeight() / 2 + loc.getY() + yy;
            return new Point(miniMapX, miniMapY);
        }
        return null;
    }

    public static int getTileHeight(@Nonnull Client client2, @Nonnull LocalPoint point, int plane) {
        int sceneX = point.getSceneX();
        int sceneY = point.getSceneY();
        if (sceneX >= 0 && sceneY >= 0 && sceneX < 104 && sceneY < 104) {
            byte[][][] tileSettings = client2.getTileSettings();
            int[][][] tileHeights = client2.getTileHeights();
            int z1 = plane;
            if (plane < 3 && (tileSettings[1][sceneX][sceneY] & 2) == 2) {
                z1 = plane + 1;
            }
            int x = point.getX() & 0x7F;
            int y = point.getY() & 0x7F;
            int var8 = x * tileHeights[z1][sceneX + 1][sceneY] + (128 - x) * tileHeights[z1][sceneX][sceneY] >> 7;
            int var9 = tileHeights[z1][sceneX][sceneY + 1] * (128 - x) + x * tileHeights[z1][sceneX + 1][sceneY + 1] >> 7;
            return (128 - y) * var8 + y * var9 >> 7;
        }
        return 0;
    }

    private static int getHeight(@Nonnull Client client2, int localX, int localY, int plane) {
        int sceneX = localX >> 7;
        int sceneY = localY >> 7;
        if (sceneX >= 0 && sceneY >= 0 && sceneX < 104 && sceneY < 104) {
            int[][][] tileHeights = client2.getTileHeights();
            int x = localX & 0x7F;
            int y = localY & 0x7F;
            int var8 = x * tileHeights[plane][sceneX + 1][sceneY] + (128 - x) * tileHeights[plane][sceneX][sceneY] >> 7;
            int var9 = tileHeights[plane][sceneX][sceneY + 1] * (128 - x) + x * tileHeights[plane][sceneX + 1][sceneY + 1] >> 7;
            return (128 - y) * var8 + y * var9 >> 7;
        }
        return 0;
    }

    public static Polygon getCanvasTilePoly(@Nonnull Client client2, @Nonnull LocalPoint localLocation) {
        return Perspective.getCanvasTileAreaPoly(client2, localLocation, 1);
    }

    public static Polygon getCanvasTileAreaPoly(@Nonnull Client client2, @Nonnull LocalPoint localLocation, int size) {
        int plane = client2.getPlane();
        int swX = localLocation.getX() - size * 128 / 2;
        int swY = localLocation.getY() - size * 128 / 2;
        int neX = localLocation.getX() + size * 128 / 2;
        int neY = localLocation.getY() + size * 128 / 2;
        int seX = swX;
        int seY = neY;
        int nwX = neX;
        int nwY = swY;
        byte[][][] tileSettings = client2.getTileSettings();
        int sceneX = localLocation.getSceneX();
        int sceneY = localLocation.getSceneY();
        if (sceneX < 0 || sceneY < 0 || sceneX >= 104 || sceneY >= 104) {
            return null;
        }
        int tilePlane = plane;
        if (plane < 3 && (tileSettings[1][sceneX][sceneY] & 2) == 2) {
            tilePlane = plane + 1;
        }
        int swHeight = Perspective.getHeight(client2, swX, swY, tilePlane);
        int nwHeight = Perspective.getHeight(client2, nwX, nwY, tilePlane);
        int neHeight = Perspective.getHeight(client2, neX, neY, tilePlane);
        int seHeight = Perspective.getHeight(client2, seX, seY, tilePlane);
        Point p1 = Perspective.localToCanvas(client2, swX, swY, swHeight);
        Point p2 = Perspective.localToCanvas(client2, nwX, nwY, nwHeight);
        Point p3 = Perspective.localToCanvas(client2, neX, neY, neHeight);
        Point p4 = Perspective.localToCanvas(client2, seX, seY, seHeight);
        if (p1 == null || p2 == null || p3 == null || p4 == null) {
            return null;
        }
        Polygon poly = new Polygon();
        poly.addPoint(p1.getX(), p1.getY());
        poly.addPoint(p2.getX(), p2.getY());
        poly.addPoint(p3.getX(), p3.getY());
        poly.addPoint(p4.getX(), p4.getY());
        return poly;
    }

    public static Point getCanvasTextLocation(@Nonnull Client client2, @Nonnull Graphics2D graphics, @Nonnull LocalPoint localLocation, @Nullable String text, int zOffset) {
        if (text == null) {
            return null;
        }
        int plane = client2.getPlane();
        Point p = Perspective.localToCanvas(client2, localLocation, plane, zOffset);
        if (p == null) {
            return null;
        }
        FontMetrics fm = graphics.getFontMetrics();
        Rectangle2D bounds = fm.getStringBounds(text, graphics);
        int xOffset = p.getX() - (int)(bounds.getWidth() / 2.0);
        return new Point(xOffset, p.getY());
    }

    public static Point getCanvasImageLocation(@Nonnull Client client2, @Nonnull LocalPoint localLocation, @Nonnull BufferedImage image, int zOffset) {
        int plane = client2.getPlane();
        Point p = Perspective.localToCanvas(client2, localLocation, plane, zOffset);
        if (p == null) {
            return null;
        }
        int xOffset = p.getX() - image.getWidth() / 2;
        int yOffset = p.getY() - image.getHeight() / 2;
        return new Point(xOffset, yOffset);
    }

    public static Point getMiniMapImageLocation(@Nonnull Client client2, @Nonnull LocalPoint localLocation, @Nonnull BufferedImage image) {
        Point p = Perspective.localToMinimap(client2, localLocation);
        if (p == null) {
            return null;
        }
        int xOffset = p.getX() - image.getWidth() / 2;
        int yOffset = p.getY() - image.getHeight() / 2;
        return new Point(xOffset, yOffset);
    }

    public static Point getCanvasSpriteLocation(@Nonnull Client client2, @Nonnull LocalPoint localLocation, @Nonnull SpritePixels sprite, int zOffset) {
        int plane = client2.getPlane();
        Point p = Perspective.localToCanvas(client2, localLocation, plane, zOffset);
        if (p == null) {
            return null;
        }
        int xOffset = p.getX() - sprite.getWidth() / 2;
        int yOffset = p.getY() - sprite.getHeight() / 2;
        return new Point(xOffset, yOffset);
    }

    @Nullable
    public static Area getClickbox(@Nonnull Client client2, Model model, int orientation, @Nonnull LocalPoint point) {
        if (model == null) {
            return null;
        }
        List<Triangle> triangles = model.getTriangles().stream().map(triangle -> triangle.rotate(orientation)).collect(Collectors.toList());
        List<Vertex> vertices = model.getVertices().stream().map(v -> v.rotate(orientation)).collect(Collectors.toList());
        Area clickBox = Perspective.get2DGeometry(client2, triangles, point);
        Area visibleAABB = Perspective.getAABB(client2, vertices, point);
        if (visibleAABB == null) {
            return null;
        }
        clickBox.intersect(visibleAABB);
        return clickBox;
    }

    private static boolean isOffscreen(@Nonnull Client client2, @Nonnull Point point) {
        return !(point.getX() >= 0 && point.getX() < client2.getViewportWidth() || point.getY() >= 0 && point.getY() < client2.getViewportHeight());
    }

    @Nonnull
    private static Area get2DGeometry(@Nonnull Client client2, @Nonnull List<Triangle> triangles, @Nonnull LocalPoint point) {
        int radius = 5;
        Area geometry = new Area();
        int tileHeight = Perspective.getTileHeight(client2, point, client2.getPlane());
        for (Triangle triangle : triangles) {
            int maxY;
            int maxX;
            int minY;
            int minX;
            Rectangle clickableRect;
            Vertex _a = triangle.getA();
            Point a = Perspective.localToCanvas(client2, point.getX() - _a.getX(), point.getY() - _a.getZ(), tileHeight + _a.getY());
            if (a == null) continue;
            Vertex _b = triangle.getB();
            Point b = Perspective.localToCanvas(client2, point.getX() - _b.getX(), point.getY() - _b.getZ(), tileHeight + _b.getY());
            if (b == null) continue;
            Vertex _c = triangle.getC();
            Point c = Perspective.localToCanvas(client2, point.getX() - _c.getX(), point.getY() - _c.getZ(), tileHeight + _c.getY());
            if (c == null || Perspective.isOffscreen(client2, a) && Perspective.isOffscreen(client2, b) && Perspective.isOffscreen(client2, c) || geometry.contains(clickableRect = new Rectangle((minX = Math.min(Math.min(a.getX(), b.getX()), c.getX())) - radius, (minY = Math.min(Math.min(a.getY(), b.getY()), c.getY())) - radius, (maxX = Math.max(Math.max(a.getX(), b.getX()), c.getX()) + 4) - minX + radius, (maxY = Math.max(Math.max(a.getY(), b.getY()), c.getY()) + 4) - minY + radius))) continue;
            geometry.add(new Area(clickableRect));
        }
        return geometry;
    }

    private static Area getAABB(@Nonnull Client client2, @Nonnull List<Vertex> vertices, @Nonnull LocalPoint point) {
        int maxX = 0;
        int minX = 0;
        int maxY = 0;
        int minY = 0;
        int maxZ = 0;
        int minZ = 0;
        for (Vertex vertex : vertices) {
            int x = vertex.getX();
            int y = vertex.getY();
            int z = vertex.getZ();
            if (x > maxX) {
                maxX = x;
            }
            if (x < minX) {
                minX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (y < minY) {
                minY = y;
            }
            if (z > maxZ) {
                maxZ = z;
            }
            if (z >= minZ) continue;
            minZ = z;
        }
        int centerX = (minX + maxX) / 2;
        int centerY = (minY + maxY) / 2;
        int centerZ = (minZ + maxZ) / 2;
        int extremeX = (maxX - minX + 1) / 2;
        int extremeY = (maxY - minY + 1) / 2;
        int extremeZ = (maxZ - minZ + 1) / 2;
        if (extremeX < 32) {
            extremeX = 32;
        }
        if (extremeZ < 32) {
            extremeZ = 32;
        }
        int x1 = point.getX() - (centerX - extremeX);
        int y1 = centerY - extremeY;
        int z1 = point.getY() - (centerZ - extremeZ);
        int x2 = point.getX() - (centerX + extremeX);
        int y2 = centerY + extremeY;
        int z2 = point.getY() - (centerZ + extremeZ);
        int tileHeight = Perspective.getTileHeight(client2, point, client2.getPlane());
        Point p1 = Perspective.localToCanvas(client2, x1, z1, tileHeight + y1);
        Point p2 = Perspective.localToCanvas(client2, x1, z2, tileHeight + y1);
        Point p3 = Perspective.localToCanvas(client2, x2, z2, tileHeight + y1);
        Point p4 = Perspective.localToCanvas(client2, x2, z1, tileHeight + y1);
        Point p5 = Perspective.localToCanvas(client2, x1, z1, tileHeight + y2);
        Point p6 = Perspective.localToCanvas(client2, x1, z2, tileHeight + y2);
        Point p7 = Perspective.localToCanvas(client2, x2, z2, tileHeight + y2);
        Point p8 = Perspective.localToCanvas(client2, x2, z1, tileHeight + y2);
        List<Point> points = new ArrayList<Point>(8);
        points.add(p1);
        points.add(p2);
        points.add(p3);
        points.add(p4);
        points.add(p5);
        points.add(p6);
        points.add(p7);
        points.add(p8);
        try {
            points = Jarvis.convexHull(points);
        }
        catch (NullPointerException e) {
            return null;
        }
        if (points == null) {
            return null;
        }
        Polygon hull = new Polygon();
        for (Point p : points) {
            if (p == null) continue;
            hull.addPoint(p.getX(), p.getY());
        }
        return new Area(hull);
    }

    public static Point getCanvasTextMiniMapLocation(@Nonnull Client client2, @Nonnull Graphics2D graphics, @Nonnull LocalPoint localLocation, @Nonnull String text) {
        Point p = Perspective.localToMinimap(client2, localLocation);
        if (p == null) {
            return null;
        }
        FontMetrics fm = graphics.getFontMetrics();
        Rectangle2D bounds = fm.getStringBounds(text, graphics);
        int xOffset = p.getX() - (int)(bounds.getWidth() / 2.0);
        int yOffset = p.getY() - (int)(bounds.getHeight() / 2.0) + fm.getAscent();
        return new Point(xOffset, yOffset);
    }

    static {
        for (int i = 0; i < 2048; ++i) {
            Perspective.SINE[i] = (int)(65536.0 * Math.sin((double)i * 0.0030679615757712823));
            Perspective.COSINE[i] = (int)(65536.0 * Math.cos((double)i * 0.0030679615757712823));
        }
    }
}

